<?php

namespace LeaseLeads\ThemeKit\Core\Providers;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

class Update extends AbstractProvider implements ProviderInterface {

    public function boot(): void
    {
        $this->checkForUpdates();
    }

    public function checkForUpdates(): void
    {
        $theme_name = config('app.name');

        if (!env()->isLocal()) {
            $checker = PucFactory::buildUpdateChecker(
                config('app.updates.url'),
                get_template_directory() . '/functions.php'
            );
        }
    }
}
