<?php

namespace LeaseLeads\ThemeKit\Core\Services;

use Illuminate\Support\Arr;
use function LeaseLeads\ThemeKit\arr;

class Config {
    /**
     * Get the value of a configuration item using dot notation.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public static function get(string $key, $default = null)
    {
        $accessor = explode('.', $key);
        $file = array_shift($accessor);
        $path = get_template_directory() . '/config/' . $file . '.php';

        if ( ! file_exists($path) ) {
            // default to the package's config file base on the callstack
            $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2);
            $caller = $backtrace[1]['file'] ?? '';
            $path = dirname($caller, 2) . '/config/' . $file . '.php';
        }

        if ( ! file_exists($path) ) {
            return $default;
        }

        $config = include $path;

        $config = is_array($config) ? $config : [];

        $value = Filter::apply("config/$file", arr($config, implode('.', $accessor), $default));
        return Filter::apply("config/$file/" . str_replace('.', '/', implode('.', $accessor)), $value);
    }

    /**
     * Get all configuration items.
     *
     * @return array
     */
    public static function all(): array
    {
        $config = [];
        $files = glob(get_template_directory() . '/config/*.php');

        foreach ($files as $file) {
            $fileName = basename($file, '.php');
            $config[$fileName] = self::get($fileName, []);
        }

        return Filter::apply('config', $config);
    }

    public static function merge($defaults, $config) {
        if (is_array($config)) {
            return array_merge_recursive($defaults, $config);
        }

        return $defaults;
    }
}
