<?php

namespace LeaseLeads\ThemeKit\Core\Services;

class Stylizer {

    public static function scale($minimum, $maximum) : static {
        $min_container_width = Theme::load()->template->font_styles['container']['minimum_width'] ?? 360;
        $max_container_width = Theme::load()->template->font_styles['container']['maximum_width'] ?? 1520;

        $slope = (($maximum - $minimum) / ($max_container_width - $min_container_width));
        $intercept = $minimum - ($slope * $min_container_width);
        $slope_vw = $slope * 100;

        return static::from("clamp({$minimum}px, calc({$slope_vw}vw + {$intercept}px), {$maximum}px)");
    }

    public static function from(string $value) : self {
        return new self($value);
    }

    public function __construct(
        public string $value = ''
    ) {}

    private function isUrl() {
        return str_starts_with($this->value, 'http://') || str_starts_with($this->value, 'https://');
    }

    public function asVariable($name) : string {
        return sprintf(
            '--%s: %s;',
            $name,
            $this->isUrl() ? "url('{$this->value}')" : $this->value
        );
    }

    public function asProperty($name) : string {
        return sprintf(
            '%s: %s;',
            $name,
            $this->isUrl() ? "url('{$this->value}')" : $this->value
        );
    }
}
