<?php

namespace LeaseLeads\ThemeKit\Core\Traits;

trait PublishesConfiguration {


    public function publishConfiguration(bool $force = false) : void{
        if ( ! property_exists($this, 'configuration') ) {
            return;
        }

        $config = $this->configuration;
        $destination = get_template_directory() . '/configs/' . basename($config, '.php') . '.php';

        if ( $force && file_exists($destination) ) {
            unlink($destination);
        }

        if ( ! is_dir(dirname($destination)) ) {
            mkdir(dirname($destination), 0755, true);
        }

        if ( ! file_exists($destination) ) {
            copy($config, $destination);
        }
    }


}
