<?php

namespace LeaseLeads\ThemeKit\Data\Traits;


use LeaseLeads\ThemeKit\Core\Contracts\FieldableInterface;
use LeaseLeads\ThemeKit\Data\Contracts\DataInterface;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;
use function LeaseLeads\ThemeKit\bound_by;

trait HasDatableFields {

    abstract public function dataClass(): string;

    public function getRawData(): array
    {
        if ( ! bound_by($this::class, FieldableInterface::class) ) {
            throw new \RuntimeException(sprintf(
                'Class %s must implement %s to use getRawData method.',
                $this::class,
                FieldableInterface::class
            ));
        }

        $this->fields($builder = new FieldsBuilder('temp'));

        return collect($builder->getFields())->mapWithKeys(fn (FieldBuilder $field) => [
            $field->getName() => get_sub_field($field->getName())
        ])->toArray();
    }


    public function getData(): DataInterface
    {
        $data = $this->getRawData();
        $class = $this->dataClass();

        if ( ! class_exists($class) ) {
            throw new \RuntimeException(sprintf(
                'Data class %s does not exist.',
                $class
            ));
        }

        if ( ! bound_by($class, DataInterface::class) ) {
            throw new \RuntimeException(sprintf(
                'Data class %s must implement %s.',
                $class,
                DataInterface::class
            ));
        }

        return $class::fromArray($data);
    }


}
