<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use StoutLogic\AcfBuilder\Builder;

class Background extends BaseField implements FieldInterface
{

    private string $defaultColor;

    public function __construct(
        string $name,
        array $args = [],
    ) {
        parent::__construct($name, $args);
        $this->defaultColor = $args['defaultColor'] ?? 'rgba(255,255,255,1)';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addFields([
                Presets::get('color', ColorSelect::class, [
                    $this->defaultColor
                ]),
                Presets::get('images', BackgroundImage::class),
            ]);
    }
}
