<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;

class ButtonAppearance extends BaseField implements FieldInterface
{
    static public function defaults() : array {
        return [
            'display' => 'outline',
            'contrast' => 'dark'
        ];
    }

    static public function cssClasses(array $appearance) : string {
        $display = 'button--display-' . $appearance['display'];
        $contrast = 'button--contrast-' . $appearance['contrast'];

        return implode(' ', [$display, $contrast]);
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addButtonGroup('display', [
                'choices' => [
                    'text' => 'Text',
                    'outline' => 'Outline Button',
                    'solid' => 'Solid Button',
                ],
                'default_value' => 'text',
            ])->setWidth(65)
            ->addButtonGroup('contrast', [
                'choices' => [
                    'light' => 'Light',
                    'dark' => 'Dark',
                ],
                'default_value' => 'light',
            ])->setWidth(35);
    }
}
