<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Data\Contracts\DatableInterface;
use LeaseLeads\ThemeKit\Data\Traits\HasDatableFields;
use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use LeaseLeads\ThemeKit\Fields\Data\ColorSelect as ColorSelectData;
use StoutLogic\AcfBuilder\Builder;

class ColorSelect extends BaseField implements FieldInterface, DatableInterface
{
    use HasDatableFields;

    public static function getCssColor(string|array|null $color)
    {
        if ( empty($color) ) {
            return '';
        }

        if ( is_string($color) ) {
            return $color;
        }

        if ( empty($color['label']) && empty($color['color']) ) {
            return '';
        }

        if ( empty($color['label']) ) {
            return $color['color'];
        }

        if (! str_starts_with(strtolower($color['label']), 'color') ) {
            return $color['color'];
        }

        return 'var(--'.sanitize_title($color['label']).')';
    }

    public static function defaults(string $color = 'rgba(255, 255, 255, 1)') : array {
        return [
            'color' => $color
        ];
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addColorPicker($this->name)
            ->setConfig('ui', 1)
            ->setConfig('enable_opacity', 1)
            ->setConfig('return_format', 'color_label')
            ->setConfig('allow_null', 0)
            ->setConfig('display', 'palette')
            ->setConfig('color_picker', 1)
            ->setConfig('absolute', true)
            ->setConfig('theme_colors', 1)
            ->setConfig('input', true);
    }

    public function dataClass(): string
    {
        return ColorSelectData::class;
    }
}
