<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\Theme\App\Data\Settings\Template;
use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;

class FontStyle extends BaseField implements FieldInterface {

//    public function __construct(string $name, array $args = [])
//    {
//        add_filter('acf/load_field/name=font_family', function($field) {
//            $field['choices'] = collect(Template::load()->font_library->fonts)
//                ->mapWithKeys(fn($fontConfig) => [$fontConfig['font_family_name'] => $fontConfig['font_family_name']])
//                ->all();
//
//            return $field;
//        });
//
//        parent::__construct($name, $args);
//    }

    public function fields(Builder $builder): void
    {
        $col = 100 / 12;

        $this->fontFamily($builder)->setWidth($col * 6);
        $this->fontCase($builder)->setWidth($col * 3);
        $this->fontWeight($builder)->setWidth($col * 3);
        $this->fontSize($builder)->setWidth($col * 3);
        $this->lineHeight($builder)->setWidth($col * 3);
        $this->letterSpacing($builder)->setWidth($col * 3);
    }

    private function fontFamily(Builder $builder): Builder
    {
        return $builder
            ->addSelect('font_family', ['choices' => [
                'default' => 'Default',
            ]]);
    }

    private function letterSpacing(Builder $builder): Builder
    {
        return $builder
            ->addNumber('letter_spacing', ['default_value' => 0])
            ->setConfig('append', 'em');
    }

    private function lineHeight(Builder $builder): Builder
    {
        return $builder
            ->addNumber('line_height', ['default_value' => 1.3])
            ->setConfig('append', 'em');
    }

    private function fontSize(Builder $builder): Builder
    {
        return $builder
            ->addNumber('minimum_size', ['default_value' => 24])
            ->setConfig('append', 'px')->setWidth(25)
            ->addNumber('maximum_size', ['default_value' => 36])
            ->setConfig('append', 'px')->setWidth(25);
    }

    private function fontWeight(Builder $builder) {
        return $builder
            ->addButtonGroup('weight')
            ->addChoice('lighter', '<i class="fa-sharp fa-thin fa-text"></i>')
            ->addChoice('normal', '<i class="fa-sharp fa-light fa-text"></i>')
            ->addChoice('bold', '<i class="fa-sharp fa-regular fa-text"></i>')
            ->addChoice('bolder', '<i class="fa-sharp fa-solid fa-text"></i>')
            ->setDefaultValue('regular');
    }

    private function fontCase(Builder $builder) {
        return $builder
            ->addButtonGroup('case')
            ->addChoice('default', '—')
            ->addChoice('uppercase', 'AB')
            ->addChoice('capitalize', 'Ab')
            ->addChoice('lowercase', 'ab')
            ->setDefaultValue('default');
    }
}
