<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;

class FormSelect extends BaseField implements FieldInterface
{

    public function fields(Builder $builder): void
    {
        $select = $builder
            ->addSelect($this->name)
            ->setConfig('ui', 1);

        if ( ! class_exists('\\GFFormsModel') ) {
            return;
        }

        $forms = \GFFormsModel::get_forms();

        foreach ($forms as $form) {
            $select->addChoice($form->id, $form->title);
        }
    }
}
