<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\Theme\App\Settings\LayoutSettings;
use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;

class LogoSelect extends BaseField implements FieldInterface
{

    static public function logoImage(?string $selection = '') : ?array {
        $property = get_field('property', 'options');

        $logos = [
            'white_logo' => $property['general']['white_logo'],
            'color_logo' => $property['general']['color_logo'],
            'black_logo' => $property['general']['black_logo'],
            'iconograph' => $property['general']['iconograph'],
        ];

        return $logos[$selection] ?? null;
    }

    static public function defaults($default = 'white_logo') : string {
        return $default;
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addSelect($this->name)
            ->setConfig('ui', 1)
            ->addChoices([
                'color_logo' => 'Color Logo',
                'white_logo' => 'White Logo',
                'black_logo' => 'Black Logo',
                'iconograph' => 'Brand Icon',
            ]);
    }
}
