<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;

class MenuSelect extends BaseField implements FieldInterface
{

    public function fields(Builder $builder): void
    {
        $menus = wp_get_nav_menus();

        $dropdown = $builder
            ->addSelect($this->name)
            ->setConfig('ui', 1);

        foreach ($menus as $menu) {
            $dropdown
                ->addChoice($menu->term_id, $menu->name);
        }
    }
}
