<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use StoutLogic\AcfBuilder\Builder;

class Pagination extends BaseField implements FieldInterface
{

    public static function defaults(): array
    {
        return [
            'icons' => ColorSelect::defaults('#000000'),
            'background' => ColorSelect::defaults('rgba(255,255,255,0.7)')
        ];
    }

    public static function cssVars(array $data): string {
        return implode("\n\t\t", [
            '--pagination-background-color:' . ColorSelect::getCssColor($data['background']) . ';',
            '--pagination-icon-color: ' . ColorSelect::getCssColor($data['icons']) . ';'
        ]);
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addFields([
                Presets::get('icons', ColorSelect::class),
                Presets::get('background', ColorSelect::class)
            ]);
    }
}
