<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use StoutLogic\AcfBuilder\Builder;

class RichMedia extends BaseField implements FieldInterface
{

    public function fields(Builder $builder): void
    {
        $builder
            ->addTab('Media')
            ->addGallery('media')
                ->setConfig('return_format', 'data')
            ->addTab('Options')
            ->addCheckbox('media_types')
                ->addChoice('video', 'Video')
                ->addChoice('iframe', 'Iframe')
                ->addChoice('virtual_tour', 'Virtual Tour')
                ->setConfig('layout', 'horizontal')
            ->addCheckbox('display')
                ->addChoice('inline')
                ->addChoice('lightbox')
                ->setConfig('layout', 'horizontal')
            ->addField('column_a', 'acfe_column', ['columns' => '6/12'])
            ->addCheckbox('video_options')
                ->addChoice('autoplay', 'Autoplay')
                ->addChoice('background', 'Background (loop, mute, hide controls)')
                ->conditional('media_types', '==contains', 'video')
                ->and('display', '==contains', 'inline')
            ->addField('column_c', 'acfe_column', ['columns' => '12/12'])
            ->addGroup('lightbox')
            ->conditional('display', '==contains', 'lightbox')
            ->addFields([
                Presets::get('button_background_color', ColorSelect::class)
                    ->setWidth(50),
                Presets::get('button_icon_color', ColorSelect::class)
                    ->setWidth(50),
            ])
            ->endGroup();
    }
}
