<?php

namespace LeaseLeads\ThemeKit\Fields\Presets;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use StoutLogic\AcfBuilder\Builder;

class Text extends BaseField implements FieldInterface
{

    public static function doText(string $content, bool $autop = false): string
    {

        // convert line separators U+2028 to spaces
        $content = str_replace("\xe2\x80\xa8", ' ', $content);

        // remove spaces that precede an <em> tag
        $content = preg_replace('/\s+(<em[^>]*>)/', '$1', $content);
        // trim spaces inside opening and closing em tags
        $content = preg_replace('/(<em[^>]*>)\s+/', '$1', $content);
        $content = preg_replace('/\s+(<\/em>)/', '$1', $content);
        // add a single space just before an <em> tag
        $content = preg_replace('/(<em[^>]*>)/', ' $1', $content);

        if ( $autop ) {
            $content = wpautop($content);
        }

        $content = do_shortcode($content);

        return $content;
    }

    public static function htmlTag(array $data) : string {
        $tag_map = [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'paragraph' => 'p',
            'fine_print' => 'small',
        ];

        return $data['tag'] ?? $tag_map[sanitize_key($data['size'])] ?? 'p';
    }

    public static function cssClass($data) : string {
        return 'font-style--'.sanitize_title($data['size']);
    }

    public static function defaults(): array
    {
        return [
            'content' => '',
            'size' => FontStyleSelect::defaults(),
            'color' => ColorSelect::defaults('#000000')
        ];
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addText('content')
            ->addFields([
                Presets::get('size', FontStyleSelect::class)
                    ->setWidth(25),
                Presets::get('color', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(0,0,0,1)')
                    ->setWidth(75),
            ]);
    }
}
