<?php
/**
 * A simple helper for creating preset fields.
 *
 * @example
 *     $builder
 *         ->addFields([
 *            Presets::get('text', Buttons::class)
 *         ])
 */

namespace LeaseLeads\ThemeKit\Fields\Services;

use LeaseLeads\ThemeKit\Fields\Contracts\FieldInterface;
use StoutLogic\AcfBuilder\Builder;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;
use function LeaseLeads\ThemeKit\bound_by;

class Presets
{
    public static function get(string $name, string $type, array $args = []): Builder
    {
        if ( ! class_exists($type) ) {
            throw new \Exception("Class $type does not exist.");
        }

        if ( ! bound_by($type, FieldInterface::class)) {
            throw new \Exception("Class $type must be a " . FieldInterface::class . ".");
        }

        $temp = new FieldsBuilder($name);
        $preset = new $type($name, $args);

        $preset->fields($temp);

        if ( count($temp->getFields()) > 1 ) {
            $builder = new FieldsBuilder($name);

            $builder
                ->addGroup($name)
                ->addFields($temp->getFields())
                ->endGroup();

            $temp = $builder;
        }

        return $temp->getFields()[0];
    }
}
