<?php

namespace LeaseLeads\ThemeKit\Plugins\Providers;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use LeaseLeads\ThemeKit\Plugins\Services\PluginLoader;
use WP_Dependency_Installer;
use function LeaseLeads\ThemeKit\config;

class Plugins extends AbstractProvider implements ProviderInterface {


    public function setup(): void
    {
        $this->installPlugins();
    }

    private function installPlugins(): void
    {
        $plugins = config('plugins.required');
        $installer = new PluginLoader();

        foreach ( $plugins as $key => $plugin_config ) {
            $plugin_slug = basename($plugin_config['slug'], '.php');

            $plugins[$key] = Filter::apply('plugins/required/' . $plugin_slug, $plugin_config);

            $installer->registerPlugin($plugin_config);
        }

        add_action('after_setup_theme', function() use ($installer) {
            $installer->install();
        });
    }
}
