<?php

namespace LeaseLeads\ThemeKit\Settings\Contracts;

use LeaseLeads\ThemeKit\Core\Contracts\FieldableInterface;

interface SectionInterface extends FieldableInterface {

    /**
     * @return string - The unique identifier for the section. Should be a valid ACF field name (snake_case);
     */
    public function name() : string;

    /**
     * @return string - The title of the section, displayed in the settings page as both the tab, and the group.
     */
    public function title() : string;

    /**
     * @return string - The slug of the settings page this section belongs to.
     */
    public function page() : string;

    /**
     * @return array - The field values of the section.
     */
    public function values() : array;

    /**
     * @return string - The transient key used to cache the section's field values.
     */
    public function transientKey(): string;
}
