<?php

namespace LeaseLeads\ThemeKit\Settings\Data;

use LeaseLeads\ThemeKit\Data\Contracts\DataInterface;
use LeaseLeads\ThemeKit\Data\Services\AbstractData;
use LeaseLeads\ThemeKit\Fields\Data\ColorSelect;

class Defaults extends AbstractData implements DataInterface {

    public static function defaults(): array
    {
        return [
            'text_color' => ColorSelect::class,
            'inline_links' => ColorSelect::class,
            'background_color' => ColorSelect::class,
            'font_family' => 'default',
        ];
    }

    public function __construct(
        public readonly ColorSelect $text_color,
        public readonly ColorSelect $inline_links,
        public readonly ColorSelect $background_color,
        public readonly string $font_family = 'default',
    ) {}

    public function __toString() : string {
        return "\n<style>\n:root {\n\t" .
            $this->colorStyles() . "\n\t" .
            Stylizer::from($this->fontFamily())->asVariable('font-family--default') .
            "\n}\n</style>\n";
    }

    public function colorStyles(): string {
        return collect([
                'text-color--default' => $this->text_color,
                'link-color--default' => $this->inline_links,
                'background-color--default' => $this->background_color,
            ])
            ->map(fn($color, $key) => $color->asVariable($key))
            ->join("\n\t");
    }

    public function fontFamily() : string {
        return match ($this->font_family) {
            'default' => Theme::load()->fonts()->first->font_family_name ?? 'inherit',
            default => $this->font_family,
        };
    }
}
