<?php

namespace LeaseLeads\ThemeKit\Settings\Providers;


use Illuminate\Support\Collection;
use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use LeaseLeads\ThemeKit\Settings\Sections\NotReady;
use LeaseLeads\ThemeKit\Settings\Services\SettingsPage;
use function LeaseLeads\ThemeKit\bound_by;
use function LeaseLeads\ThemeKit\config;
use function LeaseLeads\ThemeKit\forget_transient;

class Settings extends AbstractProvider implements ProviderInterface {

    protected Collection $pages;

    protected Collection $sections;

    public function register() : void {
        // Create the page builder service for each settings page defined in the config
        $this->pages = collect(config('settings.pages'))
            ->filter(fn ($page) => is_array($page))
            ->mapWithKeys(fn($page) => [$page['slug'] => new SettingsPage($page)]);

        $this->sections = collect(config('settings.sections', []))
            ->filter(fn ($class) => is_string($class) && class_exists($class))
            ->filter(fn ($class) => bound_by($class, SectionInterface::class))
            ->map(fn (string $class) => new $class())
            ->each(fn (SectionInterface $section) => $this->pages[$section->page()]
                ->registerSection($section))
            ->each(fn (SectionInterface $section) => $this->bootSection($section));
    }

    protected function bootSection(SectionInterface $section) : void {
        add_action(
            'acf/options_page/save',
            fn($post_id, $menu_slug) => forget_transient($section->transientKey()),
            10, 2);
    }

    public function boot() : void {
        // Build the settings page and its sections
        add_action('acf/init', function() {
            $this->pages
                ->each(fn(SettingsPage $page) => $page->build());
        });
    }

}
