<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;
use function LeaseLeads\ThemeKit\forget_transient;
use function LeaseLeads\ThemeKit\remember_transient;

abstract class AbstractSection implements SectionInterface {

    public function transientKey(): string
    {
        return "settings/{$this->page()}/section/{$this->name()}";
    }

    public function values() : array {
        return remember_transient(
            $this->transientKey(),
            fn() => get_fields('options')[$this->page()][$this->name()] ?? []);
    }

    public function name(): string
    {
        return str_replace('-', '_', sanitize_key($this->title()));
    }

    abstract public function page() : string;

    abstract public function fields(Builder $builder): void;

    abstract public function title(): string;

}
