<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Fields\Presets\ColorSelect;
use LeaseLeads\ThemeKit\Fields\Presets\FontStyle;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;

class Buttons extends AbstractSection implements SectionInterface
{
    public function title(): string
    {
        return 'Buttons';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addFields([
                Presets::get('typography', FontStyle::class)
            ])
            ->addGroup('outline_button')
            ->addFields([
                Presets::get('dark_color', ColorSelect::class)->setWidth(100/3),
                Presets::get('light_color', ColorSelect::class)->setWidth(100/3),
                Presets::get('accent_color', ColorSelect::class)->setWidth(100/3),
            ])
            ->endGroup()
            ->addGroup('solid_button')
            ->addFields([
                Presets::get('dark_button_background', ColorSelect::class)->setWidth(100/3),
                Presets::get('light_button_background', ColorSelect::class)->setWidth(100/3),
                Presets::get('accent_button_background', ColorSelect::class)->setWidth(100/3),
                Presets::get('dark_button_text', ColorSelect::class)->setWidth(100/3),
                Presets::get('light_button_text', ColorSelect::class)->setWidth(100/3),
                Presets::get('accent_button_text', ColorSelect::class)->setWidth(100/3),
            ])
            ->endGroup()
            ->addGroup('text_button')
            ->addFields([
                Presets::get('dark_color', ColorSelect::class)->setWidth(100/3),
                Presets::get('light_color', ColorSelect::class)->setWidth(100/3),
                Presets::get('accent_color', ColorSelect::class)->setWidth(100/3),
            ])
            ->endGroup();
    }

    public function page(): string
    {
        return 'layout-settings';
    }
}
