<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Fields\Presets\ColorSelect;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;

class Defaults extends AbstractSection implements SectionInterface
{

    public function title(): string
    {
        return 'Defaults';
    }

    public function page(): string
    {
        return 'layout-settings';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addFields([
                Presets::get('text_color', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(0,0,0,1)'),
                Presets::get('inline_links', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(0,0,0,1)'),
                Presets::get('background_color', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(255,255,255,1)'),
            ])
            ->addSelect('font_family', ['choices' => [
                'default' => 'Default',
            ]]);
    }
}
