<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Fields\Presets\FontStyle;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;

class FontStyles extends AbstractSection implements SectionInterface
{
    static array $font_styles = [
        'display_h1' => 'Display H1',
        'display_h2' => 'Display H2',
        'display_h3' => 'Display H3',
        'h1' => 'H1',
        'h2' => 'H2',
        'h3' => 'H3',
        'h4' => 'H4',
        'h5' => 'H5',
        'h6' => 'H6',
        'paragraph' => 'Paragraph',
        'fine_print' => 'Fine Print',
    ];

    public function title(): string
    {
        return 'Font Styles';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addMessage('Font Styles', 'Set the minimum and maximum font sizes for each style. The minimum will be used on mobile, the maximum on desktop, and will scale fluidly in-between.')
            ->addGroup('container')->setInstructions('These numbers determine the screen width range for the font size to scale between.')
            ->addNumber('minimum_width', ['default_value' => 360])->setWidth(50)
            ->setConfig('append', 'px')
            ->addNumber('maximum_width', ['default_value' => 1520])->setWidth(50)
            ->setConfig('append', 'px')
            ->endGroup();

        foreach(array_keys(static::$font_styles) as $name) {
            $builder->addFields([
                Presets::get($name, FontStyle::class)
            ]);
        }
    }

    public function page(): string
    {
        return 'layout-settings';
    }
}
