<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;
use function LeaseLeads\ThemeKit\buffered;

class NotReady extends AbstractSection implements SectionInterface {

    public function title(): string
    {
        return 'Oops!';
    }

    public function fields(Builder $builder): void
    {
        $message = buffered(function () {
            ?>
            <div class="section-content">
                <div class="section-header"><h1>Cart, meet horse!</h1><hr></div>
                <p>You need to set up the theme before you can customize the layout.</p>
                <p>
                    <a href="/wp-admin/admin.php?page=theme-settings" class="button button-primary">Setup Theme</a>
                </p>
            </div>
            <?php
        });

        $builder
            ->addMessage('', $message);
    }

    public function page(): string
    {
        return 'layout-settings';
    }
}
