<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;
use StoutLogic\AcfBuilder\GroupBuilder;

class Property extends AbstractSection implements SectionInterface {

    public function title(): string
    {
        return 'Property';
    }

    private function general(GroupBuilder $builder) : void {
        $builder
            ->addTab('General', ['placement' => 'top'])
            ->addGroup('general', ['layout' => 'block'])
            ->addText('community_name', [
                'instructions' => 'You can dynamically insert the community name anywhere in your content with the [community_name] shortcode.',
            ])
            ->addGoogleMap('property_address')
            ->setInstructions('Please add your google maps API key in the API Keys tab before adding you address here.')
            ->addField('column_a', 'acfe_column', ['columns' => '3/12'])
            ->addImage('color_logo')
            ->addField('column_b', 'acfe_column', ['columns' => '3/12'])
            ->addImage('white_logo')
            ->addField('column_c', 'acfe_column', ['columns' => '3/12'])
            ->addImage('black_logo')
            ->addField('column_d', 'acfe_column', ['columns' => '3/12'])
            ->addImage('iconograph')
            ->endGroup();
    }

    private function apiKeys(GroupBuilder $builder) : void {
        $builder
            ->addTab('API Keys', ['placement' => 'top'])
            ->addGroup('api_keys', ['layout' => 'block'])
            ->addText('google_maps')
            ->endGroup();
    }

    public function page(): string
    {
        return 'theme-settings';
    }

    public function fields(Builder $builder): void
    {
        $this->general($builder);
        $this->apiKeys($builder);
    }
}
