<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;
use StoutLogic\AcfBuilder\GroupBuilder;

class Template extends AbstractSection implements SectionInterface
{
    public function title(): string
    {
        return 'Template';
    }

    private function fontLibrary(GroupBuilder $builder) : void {
        $builder->addTab('Font Library', ['placement' => 'top'])
            ->addGroup('font_library')
            ->addTextArea('scripts')
            ->setInstructions('Add your scripts or stylesheets here to load the fonts. Usually pulled from Google or Typekit.')
            ->addRepeater('fonts')
            ->setInstructions('For each font that your scripts load, add the font family name here.')
            ->setConfig('button_label', 'Add Font Name')
            ->addText('font_family_name')
            ->addNumber('lighter_weight', ['label' => 'Lighter Weight'])
            ->setConfig('min', 100)
            ->setConfig('max', 1000)
            ->setConfig('step', 100)
            ->setDefaultValue(100)
            ->addNumber('normal_weight', ['label' => 'Normal Weight'])
            ->setConfig('min', 100)
            ->setConfig('max', 1000)
            ->setConfig('step', 100)
            ->setDefaultValue(400)
            ->addNumber('bold_weight', ['label' => 'Bold Weight'])
            ->setConfig('min', 100)
            ->setConfig('max', 1000)
            ->setConfig('step', 100)
            ->setDefaultValue(700)
            ->addNumber('bolder_weight', ['label' => 'Bolder Weight'])
            ->setConfig('min', 100)
            ->setConfig('max', 1000)
            ->setConfig('step', 100)
            ->setDefaultValue(900)
            ->endRepeater()
            ->endGroup();
    }

    private function colorLibrary(GroupBuilder $builder) : void {
        $builder
            ->addTab('Colors', ['placement' => 'top'])
            ->addRepeater('colors')
            ->addColorPicker('color', ['return_format' => 'string'])
            ->setConfig('enable_opacity', 1)
            ->endRepeater();
    }

    public function page(): string
    {
        return 'theme-settings';
    }

    public function fields(Builder $builder): void
    {
        if (! $builder instanceof GroupBuilder) {
            throw new \InvalidArgumentException('Builder must be an instance of GroupBuilder.');
        }

        $this->fontLibrary($builder);
        $this->colorLibrary($builder);
    }
}
